<?php
include __DIR__ . '/../config/db.php';
session_start();

if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

if (!isset($_GET['id'])) {
    echo "<script>alert('ID invoice tidak diberikan.'); window.location.href='list_invoice.php';</script>";
    exit;
}

$invoice_id = intval($_GET['id']);

// Fetch invoice master data
$stmt = $conn->prepare("SELECT * FROM invoice WHERE id = ?");
$stmt->bind_param("i", $invoice_id);
$stmt->execute();
$invoice_result = $stmt->get_result();
$invoice = $invoice_result->fetch_assoc();
$stmt->close();

if (!$invoice) {
    echo "<script>alert('Invoice tidak ditemukan.'); window.location.href='list_invoice.php';</script>";
    exit;
}

// Fetch surat jalan related to invoice
$stmt2 = $conn->prepare("SELECT sj.no_surat, sj.jenis_barang, sj.tujuan, sj.tonase, sj.harga_kg, sj.jumlah_nilai 
    FROM surat_jalan sj
    INNER JOIN invoice_surat_jalan isl ON sj.id = isl.surat_jalan_id
    WHERE isl.invoice_id = ?");
$stmt2->bind_param("i", $invoice_id);
$stmt2->execute();
$details_result = $stmt2->get_result();
$details = $details_result->fetch_all(MYSQLI_ASSOC);
$stmt2->close();

// Fetch spareparts related to invoice
$stmt3 = $conn->prepare("SELECT nama_sparepart, nilai_sparepart FROM invoice_sparepart WHERE invoice_id = ?");
$stmt3->bind_param("i", $invoice_id);
$stmt3->execute();
$spareparts_result = $stmt3->get_result();
$spareparts = $spareparts_result->fetch_all(MYSQLI_ASSOC);
$stmt3->close();

// Assign values from invoice
$manual_penerima = $invoice['penerima_manual'];
$manual_alamat = $invoice['alamat_manual'];
$due_date = $invoice['due_date'];
$invoice_no = $invoice['no_invoice'];
$invoice_date = date('d F Y', strtotime($invoice['created_at']));
$pph_percentage = (float)$invoice['pph'];
$pph_amount = $invoice['total_nilai'] * ($pph_percentage / 100);
$uang_makan = $invoice['uang_makan'] ?? 0;
$uang_kenek = $invoice['uang_kenek'] ?? 0;
$uang_parkir = $invoice['uang_parkir'] ?? 0;
$charge_invoice = $invoice['charge_invoice'] ?? 0;
$metode_pembayaran = $invoice['metode_pembayaran'] ?? 'Cash';

$total_sparepart_nilai = array_sum(array_column($spareparts, 'nilai_sparepart'));
$total_after_all = $invoice['total_nilai'] + $pph_amount + $charge_invoice + $total_sparepart_nilai + $uang_makan + $uang_kenek + $uang_parkir;
$total_tonase = array_sum(array_column($details, 'tonase'));
$total_nilai = array_sum(array_column($details, 'jumlah_nilai'));
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Detail Invoice - <?= htmlspecialchars($invoice_no) ?></title>
<link rel="stylesheet" href="style_invoice.css">
</head>
<body>

<div class="header-info">
    <img src="../assets/images/logo1.png" alt="Logo PT. Cahaya Berkat Mitra" />
    <div class="company-info">
        PT. CAHAYA BERKAT MITRA<br />
        Jl. Raya Imam Bonjol No. 90 RT. 003 RW. 006<br />
        Telaga Murni, Cikarang Barat, Kab. Bekasi, Jawa Barat<br />
        +6281280669996
    </div>
</div>

<div class="info-container">
    <div class="bill-to">
        <h3>Bill To:</h3>
        <div><?= htmlspecialchars($manual_penerima) ?></div>
        <div class="delivery-address"><?= nl2br(htmlspecialchars($manual_alamat)) ?></div>
    </div>
    <div class="invoice-info">
        <div class="title">INVOICE</div>
        <div><strong>No. Invoice:</strong> <?= htmlspecialchars($invoice_no) ?></div>
        <div><strong>Tanggal Invoice:</strong> <?= $invoice_date ?></div>
        <div><strong>Due Date:</strong> <?= date('d F Y', strtotime($due_date)) ?></div>
        <div><strong>Metode Pembayaran:</strong> <?= htmlspecialchars($metode_pembayaran) ?></div>
    </div>
</div>

<table>
<thead>
<tr>
<th>No. Surat Jalan</th>
<th>Nama Barang</th>
<th>Tujuan</th>
<th class="number">Tonase</th>
<th class="number">Harga/kg</th>
<th class="number">Jumlah Nilai</th>
</tr>
</thead>
<tbody>
<?php if (!empty($details)) : ?>
    <?php foreach ($details as $d) : ?>
    <tr>
        <td><?= htmlspecialchars($d['no_surat']) ?></td>
        <td><?= htmlspecialchars($d['jenis_barang']) ?></td>
        <td><?= htmlspecialchars($d['tujuan']) ?></td>
        <td class="number"><?= number_format($d['tonase'], 2) ?></td>
        <td class="number"><?= number_format($d['harga_kg'], 2) ?></td>
        <td class="number"><?= number_format($d['jumlah_nilai'], 2) ?></td>
    </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr><td colspan="6" style="text-align:center;">Tidak ada data Surat Jalan terkait.</td></tr>
<?php endif; ?>
</tbody>
<tfoot>
<tr>
    <td colspan="3" style="text-align: right;">Total:</td>
    <td class="number"><?= number_format($total_tonase, 2) ?></td>
    <td></td>
    <td class="number"><?= number_format($total_nilai, 2) ?></td>
</tr>
<?php if ($pph_percentage > 0): ?>
<tr>
    <td colspan="5" style="text-align: right;">PPH (<?= number_format($pph_percentage,2) ?>%):</td>
    <td class="number">Rp <?= number_format($pph_amount, 2) ?></td>
</tr>
<?php endif; ?>
<tr>
    <td colspan="5" style="text-align: right;">Charge:</td>
    <td class="number">Rp <?= number_format($charge_invoice,2) ?></td>
</tr>
<?php if ($uang_makan): ?>
<tr><td colspan="5" style="text-align:right;">Uang Jalan:</td><td class="number">Rp <?= number_format($uang_makan, 2) ?></td></tr>
<?php endif; ?>
<?php if ($uang_kenek): ?>
<tr><td colspan="5" style="text-align:right;">Uang Kenek:</td><td class="number">Rp <?= number_format($uang_kenek, 2) ?></td></tr>
<?php endif; ?>
<?php if ($uang_parkir): ?>
<tr><td colspan="5" style="text-align:right;">Uang Parkir:</td><td class="number">Rp <?= number_format($uang_parkir, 2) ?></td></tr>
<?php endif; ?>
<?php if ($total_sparepart_nilai): ?>
<tr><td colspan="5" style="text-align:right;">Total Spareparts:</td><td class="number">Rp <?= number_format($total_sparepart_nilai, 2) ?></td></tr>
<?php endif; ?>
<tr style="border-top: 2px solid #000;">
    <td colspan="5" style="text-align:right;font-weight:700;">Total Setelah Semua Biaya:</td>
    <td class="number" style="font-weight:700;">Rp <?= number_format($total_after_all, 2) ?></td>
</tr>
</tfoot>
</table>

<div class="amounts-box">
<strong>Spare Part:</strong>
<ul>
<?php if (!empty($spareparts)) : ?>
    <?php foreach ($spareparts as $sp) : ?>
        <li><?= htmlspecialchars($sp['nama_sparepart']) ?>: Rp <?= number_format($sp['nilai_sparepart'], 2) ?></li>
    <?php endforeach; ?>
<?php else: ?>
    <li>(Tidak ada sparepart)</li>
<?php endif; ?>
</ul>
</div>

<button onclick="window.print()" class="btn-cetak no-print">🖨️ Cetak</button>
<br>
<a href="list_invoice.php" class="back-link no-print">← Kembali ke Daftar Invoice</a>

<div class="payment-info no-print">
    Mohon pembayaran di transfer ke:<br />
    Rek Bank BCA No Rek : 5222406889 a/n PT. Cahaya Berkat Mitra Sarana
</div>

<div class="footer-info">
    <p>Terima kasih</p>
    <p><?= date('d F Y') ?></p>
</div>

<?php $conn->close(); ?>
</body>
</html>
