<?php
// File: surat_jalan/edit_surat.php
include __DIR__ . '/../config/db.php';

if (!isset($_GET['id'])) {
    echo "ID tidak ditemukan.";
    exit;
}

$id = intval($_GET['id']);
$sql = "SELECT * FROM surat_jalan WHERE id = $id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    echo "Data tidak ditemukan.";
    exit;
}

$data = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Edit Surat Jalan</title>
    <link rel="stylesheet" href="../assets/css/style.css" />
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #6a11cb, #2575fc);
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 12px 30px rgba(0,0,0,0.15);
        }
        h2 {
            color: #2575fc;
            text-align: center;
        }
        label {
            font-weight: bold;
        }
        input[type="text"],
        input[type="number"] {
            width: 100%;
            padding: 10px;
            margin: 5px 0 20px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }
        input[type="submit"] {
            background-color: #2575fc;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
        }
        input[type="submit"]:hover {
            background-color: #1a54d6;
        }
        .no-print {
            margin-top: 20px;
            display: block;
            text-align: center;
            color: #2575fc;
            font-weight: bold;
        }
        .no-print:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Surat Jalan</h2>
        <form action="update_surat.php" method="post">
            <input type="hidden" name="id" value="<?= $data['id'] ?>">
            <label>No. Surat Jalan:</label>
            <input type="text" name="no_surat" value="<?= htmlspecialchars($data['no_surat']) ?>" required>

            <label>No. Polisi:</label>
            <input type="text" name="no_pol" value="<?= htmlspecialchars($data['no_pol']) ?>" required>

            <label>Jenis Barang:</label>
            <input type="text" name="jenis_barang" value="<?= htmlspecialchars($data['jenis_barang']) ?>" required>

            <label>Tujuan:</label>
            <input type="text" name="tujuan" value="<?= htmlspecialchars($data['tujuan']) ?>" required>

            <label>Tonase (kg):</label>
            <input type="number" name="tonase" step="0.01" value="<?= $data['tonase'] ?>" required>

            <label>Harga per Kg:</label>
            <input type="number" name="harga_per_kg" step="0.01" value="<?= $data['harga_kg'] ?>" required>

            <label>Jumlah Nilai:</label>
            <input type="number" name="jumlah_nilai" step="0.01" value="<?= $data['jumlah_nilai'] ?>" required>

            <input type="submit" value="Simpan Perubahan">
        </form>
        <a href="list_surat.php" class="no-print">← Kembali ke daftar</a>
    </div>
</body>
</html>

<?php
$conn->close();
?>