<?php
include '../config/db.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['nopol']) && !empty($_POST['nopol'])) {
        $nopol = trim($_POST['nopol']);
        $month = intval($_POST['month']);
        $year = intval($_POST['year']);

        // Prepare the SQL query
        $sql = "
            SELECT 
                sj.no_surat,
                sj.no_pol,
                sj.jenis_barang,
                sj.tujuan,
                sj.tonase,
                sj.harga_kg,
                sj.jumlah_nilai,
                i.spare_part, 
                i.uang_makan, 
                i.uang_kenek, 
                i.uang_parkir
            FROM surat_jalan sj
            LEFT JOIN invoice_surat_jalan isj ON sj.id = isj.surat_jalan_id
            LEFT JOIN invoice i ON isj.invoice_id = i.id
            WHERE sj.no_pol = ? AND MONTH(sj.tanggal) = ? AND YEAR(sj.tanggal) = ?
            ORDER BY sj.tanggal ASC
        ";

        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("sii", $nopol, $month, $year);
            $stmt->execute();
            $result = $stmt->get_result();

            // Prepare the data for Excel
            $data = [];
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            $stmt->close();

            // Set headers for Excel download
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment; filename="invoice_report_' . $nopol . '_' . $month . '_' . $year . '.xls"');

            // Output the data
            echo "No. Surat Jalan\tNomor Polisi\tJenis Barang\tTujuan\tTonase\tHarga/kg\tJumlah Nilai\tSpare Part (Rp)\tUang Makan (Rp)\tUang Kenek (Rp)\tUang Parkir (Rp)\n";
            foreach ($data as $row) {
                echo implode("\t", [
                    $row['no_surat'],
                    $row['no_pol'],
                    $row['jenis_barang'],
                    $row['tujuan'],
                    number_format($row['tonase'], 2),
                    number_format($row['harga_kg'], 2),
                    number_format($row['jumlah_nilai'], 2),
                    number_format($row['spare_part'] ?? 0, 2),
                    number_format($row['uang_makan'] ?? 0, 2),
                    number_format($row['uang_kenek'] ?? 0, 2),
                    number_format($row['uang_parkir'] ?? 0, 2),
                ]) . "\n";
            }
            exit;
        }
    }
}
?>
