<?php
// File: surat_jalan/save_surat.php
include '../config/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil data dari form
    $no_surat = $_POST['no_surat'];
    $no_pol = $_POST['no_pol'];
    $jenis_barang = $_POST['jenis_barang'];
    $tujuan = $_POST['tujuan'];
    $tonase = $_POST['tonase'];
    $harga_kg = $_POST['harga_kg'];
    $charge = $_POST['charge']; // Ambil nilai charge

    // Validasi charge
    if (!is_numeric($charge)) {
        die("Charge harus berupa angka.");
    }

    // Siapkan query untuk menyimpan data
    $sql = "INSERT INTO surat_jalan (no_surat, no_pol, jenis_barang, tujuan, tonase, harga_kg, charge) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";

    // Siapkan statement
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Error preparing statement: " . $conn->error);
    }

    // Bind parameter
    $stmt->bind_param("ssssdds", $no_surat, $no_pol, $jenis_barang, $tujuan, $tonase, $harga_kg, $charge);

    // Eksekusi statement
    if ($stmt->execute()) {
        echo "Data berhasil disimpan.";
    } else {
        echo "Error: " . $stmt->error; // Menampilkan pesan kesalahan
    }

    // Tutup statement dan koneksi
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Input Surat Jalan</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <h2>Input Surat Jalan</h2>
    <form action="save_surat.php" method="post">
        <table>
            <tr>
                <td>No. Surat Jalan</td>
                <td><input type="text" name="no_surat" required></td>
            </tr>
            <tr>
                <td>No. Polisi</td>
                <td><input type="text" name="no_pol" required></td>
            </tr>
            <tr>
                <td>Jenis Barang</td>
                <td><input type="text" name="jenis_barang" required></td>
            </tr>
            <tr>
                <td>Tujuan</td>
                <td><input type="text" name="tujuan" required></td>
            </tr>
            <tr>
                <td>Tonase (kg)</td>
                <td><input type="number" step="0.001" name="tonase" required></td>
            </tr>
            <tr>
                <td>Harga / kg</td>
                <td><input type="number" name="harga_kg" required></td>
            </tr>
            <tr>
    <td>Charge</td>
    <td><input type="number" name="charge" step="0.01" required></td>
</tr>
            <tr>
                <td><button type="submit">Simpan</button></td>
                <td><a href="list_surat.php">Lihat Data</a></td>
            </tr>
        </table>
    </form>
</body>
</html>
