<?php
include '../config/db.php';
session_start();

$rows = [];
$spareparts_by_invoice = [];
$total_tonase = $total_nilai = 0;
$total_sparepart = $total_uang_makan = $total_uang_kenek = $total_uang_parkir = 0;
$nopol = '';
$month = 0;
$year = 0;
$invoice_ids = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['nopol']) && !empty($_POST['nopol'])) {
        $nopol = trim($_POST['nopol']);
        $month = intval($_POST['month']);
        $year = intval($_POST['year']);

        // Improved query to prevent SQL errors
        $sql = "
            SELECT 
                sj.id,
                sj.no_surat,
                sj.no_pol,
                sj.jenis_barang,
                sj.tujuan,
                sj.tonase,
                sj.harga_kg,
                sj.jumlah_nilai,
                sj.tanggal AS tanggal_sj,
                i.id AS invoice_id, 
                i.spare_part, 
                i.uang_makan, 
                i.uang_kenek, 
                i.uang_parkir
            FROM surat_jalan sj
            LEFT JOIN invoice_surat_jalan isj ON sj.id = isj.surat_jalan_id
            LEFT JOIN invoice i ON isj.invoice_id = i.id
            WHERE sj.no_pol = ? AND MONTH(sj.tanggal) = ? AND YEAR(sj.tanggal) = ?
            ORDER BY sj.tanggal ASC
        ";

        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("sii", $nopol, $month, $year);
            $stmt->execute();
            $result = $stmt->get_result();

            while ($row = $result->fetch_assoc()) {
                $rows[] = $row;
                $total_tonase += $row['tonase'];
                $total_nilai += $row['jumlah_nilai'] ?? 0;
                if ($row['invoice_id']) {
                    $invoice_ids[] = $row['invoice_id'];
                    $total_sparepart += $row['spare_part'] ?? 0;
                    $total_uang_makan += $row['uang_makan'] ?? 0;
                    $total_uang_kenek += $row['uang_kenek'] ?? 0;
                    $total_uang_parkir += $row['uang_parkir'] ?? 0;
                }
            }
            $stmt->close();
        }

        // Spare parts retrieval
        if (!empty($invoice_ids)) {
            $ids_str = implode(',', array_map('intval', array_unique($invoice_ids)));
            $sql_spare = "SELECT invoice_id, nama_sparepart, nilai_sparepart FROM invoice_sparepart WHERE invoice_id IN ($ids_str)";
            if ($result_spare = $conn->query($sql_spare)) {
                while ($spare = $result_spare->fetch_assoc()) {
                    $invoice_id = $spare['invoice_id'];
                    if (!isset($spareparts_by_invoice[$invoice_id])) {
                        $spareparts_by_invoice[$invoice_id] = [];
                    }
                    $spareparts_by_invoice[$invoice_id][] = $spare;
                }
            }
        }
    }
}

// Functions for month name and date formatting
function monthName($month) {
    $names = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
    return $names[$month - 1] ?? '';
}

function formatDateIndo($dateStr) {
    return $dateStr ? date('d-m-Y', strtotime($dateStr)) : '';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Invoice Surat Jalan - Laporan Bulanan</title>
    <link rel="stylesheet" href="../assets/css/style.css" />
    <style>
        body { font-family: Arial, sans-serif; padding: 15px; background: #fefefe; max-width: 900px; margin: auto; }
        label { display: block; margin-top: 10px; font-weight: bold; }
        input[type=text], select { width: 100%; padding: 8px; margin-top: 5px; }
        button { margin-top: 15px; background-color: #3e82ff; border: none; color: white; padding: 12px; cursor: pointer; border-radius: 5px; font-weight: bold; }
        button:hover { background-color: #3466d9; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: center; vertical-align: middle; }
        th { background-color: #3e82ff; color: white; }
        .totals { font-weight: bold; }
        .form-inline { display: flex; gap: 10px; flex-wrap: wrap; margin-bottom: 20px; }
        .form-inline > * { flex: 1; }
        .invoice-section { margin-top: 30px; }
        .sparepart-table { margin-top: 15px; width: 50%; }
        .sparepart-table th, .sparepart-table td { border: 1px solid #ccc; padding: 6px; text-align: left; }
    </style>
</head>
<body>
<h1>Cari Invoice Berdasarkan Nomor Polisi</h1>
<form method="post" autocomplete="off">
    <label for="nopol">Nomor Polisi</label>
    <input type="text" id="nopol" name="nopol" value="<?= htmlspecialchars($nopol) ?>" required />

    <div class="form-inline">
        <div>
            <label for="month">Bulan</label>
            <select id="month" name="month" required>
                <option value="">-- Pilih Bulan --</option>
                <?php for ($m = 1; $m <= 12; $m++): ?>
                    <option value="<?= $m ?>" <?= ($month == $m) ? 'selected' : '' ?>><?= monthName($m) ?></option>
                <?php endfor; ?>
            </select>
        </div>
        <div>
            <label for="year">Tahun</label>
            <select id="year" name="year" required>
                <option value="">-- Pilih Tahun --</option>
                <?php for ($y = date('Y'); $y >= 2020; $y--): ?>
                    <option value="<?= $y ?>" <?= ($year == $y) ? 'selected' : '' ?>><?= $y ?></option>
                <?php endfor; ?>
            </select>
        </div>
    </div>

    <button type="submit">Cari</button>
</form>

<?php if (!empty($rows)): ?>
<div class="invoice-section">
    <h2>Detail Surat Jalan dan Biaya untuk <?= htmlspecialchars($nopol) ?> Bulan <?= monthName($month) ?> <?= $year ?></h2>
    <table>
        <thead>
            <tr>
                <th>No. Surat Jalan</th>
                <th>Nomor Polisi</th>
                <th>Jenis Barang</th>
                <th>Tujuan</th>
                <th>Tonase</th>
                <th>Harga/kg</th>
                <th>Jumlah Nilai</th>
                <th>Spare Part (Rp)</th>
                <th>Uang Makan (Rp)</th>
                <th>Uang Kenek (Rp)</th>
                <th>Uang Parkir (Rp)</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row): ?>
            <tr>
                <td><?= htmlspecialchars($row['no_surat']) ?></td>
                <td><?= htmlspecialchars($row['no_pol']) ?></td>
                <td><?= htmlspecialchars($row['jenis_barang']) ?></td>
                <td><?= htmlspecialchars($row['tujuan']) ?></td>
                <td><?= number_format($row['tonase'], 2) ?></td>
                <td><?= number_format($row['harga_kg'], 2) ?></td>
                <td><?= number_format($row['jumlah_nilai'], 2) ?></td>
                <td><?= number_format($row['spare_part'] ?? 0, 2) ?></td>
                <td><?= number_format($row['uang_makan'] ?? 0, 2) ?></td>
                <td><?= number_format($row['uang_kenek'] ?? 0, 2) ?></td>
                <td><?= number_format($row['uang_parkir'] ?? 0, 2) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr class="totals">
                <td colspan="4" style="text-align: right;">Total</td>
                <td><?= number_format($total_tonase, 2) ?></td>
                <td></td>
                <td><?= number_format($total_nilai, 2) ?></td>
                <td><?= number_format($total_sparepart, 2) ?></td>
                <td><?= number_format($total_uang_makan, 2) ?></td>
                <td><?= number_format($total_uang_kenek, 2) ?></td>
                <td><?= number_format($total_uang_parkir, 2) ?></td>
            </tr>
        </tfoot>
    </table>

    <?php if (!empty($invoice_ids)): ?>
    <h3>Detail Nama Sparepart per Invoice</h3>
    <?php foreach (array_unique($invoice_ids) as $inv_id): ?>
        <h4>Invoice ID: <?= htmlspecialchars($inv_id) ?></h4>
        <?php if (isset($spareparts_by_invoice[$inv_id]) && count($spareparts_by_invoice[$inv_id]) > 0): ?>
        <table class="sparepart-table">
            <thead>
                <tr>
                    <th>Nama Sparepart</th>
                    <th>Nilai (Rp)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($spareparts_by_invoice[$inv_id] as $spare): ?>
                <tr>
                    <td><?= htmlspecialchars($spare['nama_sparepart']) ?></td>
                    <td><?= number_format($spare['nilai_sparepart'], 2) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
            <p>Tidak ada data sparepart untuk invoice ini.</p>
        <?php endif; ?>
    <?php endforeach; ?>
    <?php endif; ?>

    <button onclick="window.print()" style="margin-top: 15px;">🖨️ Cetak Laporan</button>
</div>
<?php elseif ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
    <p>Data untuk nomor polisi <strong><?= htmlspecialchars($nopol) ?></strong> bulan <?= monthName($month) ?> <?= $year ?> tidak ditemukan.</p>
<?php endif; ?>

</body>
</html>
<?php
$conn->close();
?>
