<?php
include __DIR__ . '/../config/db.php';
session_start();

if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Initialize variables
$manual_invoice_no = isset($_POST['manual_invoice_no']) ? trim($_POST['manual_invoice_no']) : '';
$pph = $uang_makan = $uang_kenek = $uang_parkir = $charge_invoice = 0;
$ids = [];
$spareparts = [];
$total_sparepart_nilai = 0.0;
$manual_penerima = '';
$manual_alamat = '';
$due_date = date('Y-m-d', strtotime('+1 month'));

// Handle POST request for saving invoice
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['selected_ids']) && is_array($_POST['selected_ids'])) {
        $metode_pembayaran = isset($_POST['metode_pembayaran']) ? $_POST['metode_pembayaran'] : 'Cash';
        $ids = array_map('intval', $_POST['selected_ids']);
        $pph = isset($_POST['pph']) ? floatval($_POST['pph']) : 0;
        $uang_makan = isset($_POST['uang_makan']) ? floatval($_POST['uang_makan']) : 0;
        $uang_kenek = isset($_POST['uang_kenek']) ? floatval($_POST['uang_kenek']) : 0;
        $uang_parkir = isset($_POST['uang_parkir']) ? floatval($_POST['uang_parkir']) : 0;
        $charge_invoice = isset($_POST['charge_invoice']) ? floatval($_POST['charge_invoice']) : 0;

        $manual_penerima = isset($_POST['manual_penerima']) ? trim($_POST['manual_penerima']) : '';
        $manual_alamat = isset($_POST['manual_alamat']) ? trim($_POST['manual_alamat']) : '';
        $due_date = isset($_POST['due_date']) ? $_POST['due_date'] : date('Y-m-d', strtotime('+1 month'));

        $sparepart_names = isset($_POST['sparepart_nama']) && is_array($_POST['sparepart_nama']) ? $_POST['sparepart_nama'] : [];
        $sparepart_nilai_arr = isset($_POST['sparepart_nilai']) && is_array($_POST['sparepart_nilai']) ? $_POST['sparepart_nilai'] : [];
        $spareparts = [];
        $total_sparepart_nilai = 0.0;

        foreach ($sparepart_names as $index => $name) {
            $name = trim($name);
            if ($name === '') continue;
            $nilai = isset($sparepart_nilai_arr[$index]) ? floatval($sparepart_nilai_arr[$index]) : 0;
            if ($nilai < 0) $nilai = 0;
            $spareparts[] = ['nama' => $name, 'nilai' => $nilai];
            $total_sparepart_nilai += $nilai;
        }
    }
} elseif (isset($_GET['selected_ids'])) {
    $ids = array_map('intval', explode(',', $_GET['selected_ids']));
} else {
    exit("Tidak ada surat jalan yang dipilih.");
}

if (count($ids) === 0) {
    exit("Tidak ada surat jalan yang dipilih.");
}

$id_list = implode(',', $ids);
$sql = "SELECT * FROM surat_jalan WHERE id IN ($id_list)";
$result = $conn->query($sql);

if (!$result) {
    exit("Gagal mengambil data surat jalan: " . $conn->error);
}

$total_tonase = 0;
$total_nilai = 0;
$rows = [];

foreach ($result as $row) {
    $rows[] = $row;
    $total_tonase += $row['tonase'];
    $row_nilai = $row['tonase'] * $row['harga_kg'];
    $total_nilai += $row_nilai;
}

if ($manual_penerima === '' && $manual_alamat === '') {
    if (!empty($rows)) {
        $manual_penerima = $rows[0]['penerima'] ?? '';
        $manual_alamat = $rows[0]['alamat_bongkar'] ?? 'Alamat tidak tersedia';
    }
}

$pph_amount = $pph > 0 ? $total_nilai * ($pph / 100) : 0;

$total_after_all = $total_nilai + $pph_amount + $charge_invoice;

$invoice_saved = false;
$invoice_date = date('d F Y');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_invoice'])) {
    if (empty($manual_penerima) || empty($manual_alamat) || empty($manual_invoice_no)) {
        echo "<script>alert('Penerima, alamat, dan nomor invoice tidak boleh kosong.');</script>";
    } else {
        $stmt = $conn->prepare("
    INSERT INTO invoice (
        no_invoice, total_tonase, total_nilai, pph, spare_part,
        uang_makan, uang_kenek, uang_parkir, charge_invoice, total_after_pph,
        penerima_manual, alamat_manual, due_date, manual_penerima, manual_alamat,
        metode_pembayaran
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

        if (!$stmt) {
            exit("Prepare failed: " . $conn->error);
        }

$stmt->bind_param(
    "sdddddddddssssss",
    $manual_invoice_no,
    $total_tonase,
    $total_nilai,
    $pph,
    $total_sparepart_nilai,
    $uang_makan,
    $uang_kenek,
    $uang_parkir,
    $charge_invoice,
    $total_after_all,
    $manual_penerima,
    $manual_alamat,
    $due_date,
    $manual_penerima,
    $manual_alamat,
    $metode_pembayaran
);

        if ($stmt->execute()) {
            $invoice_saved = true;
            $invoice_id = $stmt->insert_id;

            $stmt_rel = $conn->prepare("INSERT INTO invoice_surat_jalan (invoice_id, surat_jalan_id) VALUES (?, ?)");
            if ($stmt_rel) {
                foreach ($ids as $surat_jalan_id) {
                    $stmt_rel->bind_param("ii", $invoice_id, $surat_jalan_id);
                    $stmt_rel->execute();
                }
                $stmt_rel->close();
            }

            $stmt_spare = $conn->prepare("INSERT INTO invoice_sparepart (invoice_id, nama_sparepart, nilai_sparepart) VALUES (?, ?, ?)");
            if ($stmt_spare) {
                foreach ($spareparts as $sparepart) {
                    $stmt_spare->bind_param("isd", $invoice_id, $sparepart['nama'], $sparepart['nilai']);
                    $stmt_spare->execute();
                }
                $stmt_spare->close();
            } else {
                echo "<script>alert('Gagal menyiapkan penyimpanan sparepart: " . htmlspecialchars($conn->error) . "');</script>";
            }
            echo "<script>alert('Invoice berhasil disimpan dengan nomor: $manual_invoice_no');</script>";
        } else {
            echo "<script>alert('Gagal menyimpan invoice: " . htmlspecialchars($stmt->error) . "');</script>";
        }
        $stmt->close();
    }
}

?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Invoice Surat Jalan</title>
<style>
  body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; margin: 20px; background: #f0f4ff; color: #333; }
  .header-info { display: flex; align-items: center; margin-bottom: 25px; }
  .header-info img { width: 180px; margin-right: 15px; }
  .company-info { font-weight: 700; font-size: 14px; line-height: 1.5; color: #333; }
  .info-container {
      display: flex;
      justify-content: space-between;
      margin-bottom: 35px;
      flex-wrap: wrap;
  }
  .bill-to {
      width: 48%;
      font-size: 15px;
      line-height: 1.5;
      background: #e8f0fe;
      padding: 15px 18px;
      border-radius: 8px;
      box-shadow: 0 0 8px rgb(62 130 255 / 0.15);
      box-sizing: border-box;
      min-width: 280px;
  }
  .bill-to h3 {
      margin: 0 0 10px 0;
      color: #3e82ff;
      font-weight: 700;
      font-size: 19px;
  }
  .delivery-address {
      margin-top: 12px;
      font-size: 14px;
      line-height: 1.4;
      color: #555;
  }
  .invoice-info {
      width: 48%;
      text-align: right;
      font-size: 15px;
      box-sizing: border-box;
      min-width: 280px;
  }
  .invoice-info .title {
      font-size: 28px;
      font-weight: 700;
      margin-bottom: 12px;
      color: #3e82ff;
      letter-spacing: 1.2px;
  }
  table { border-collapse: collapse; width: 100%; margin-bottom: 25px; font-size: 15px; box-shadow: 0 0 8px rgba(0,0,0,0.1); background: #fff; border-radius: 8px; overflow: hidden; }
  th, td { border: 1px solid #ddd; padding: 12px 15px; text-align: left; }
  th { background-color: #3e82ff; color: #fff; font-weight: 700; }
  tfoot td { font-weight: 700; background: #f9f9f9; }
  tfoot tr td:nth-child(n+4) { text-align: right; }
  .amounts-box { border: 1px solid #ccc; padding: 15px; background-color: #f9f9f9; font-size: 15px; max-width: 380px; margin-bottom: 30px; float: right; border-radius: 8px; }
  .amounts-box strong { display: block; margin-bottom: 8px; color: #3e82ff; font-weight: 700; }
  .amounts-box ul { margin: 8px 0 12px 20px; padding: 0; list-style-type: disc; }
  .amounts-box ul li { margin-bottom: 5px; }
  .payment-info { clear: both; font-size: 15px; font-weight: 700; margin-top: 50px; color: #333; float: left; width: 50%; }
  .footer-info { text-align: right; margin-top: 50px; font-size: 15px; font-weight: 700; color: #333; float: right; width: 50%; }
  @media print {
      .no-print { display: none !important; }
      body {
          -webkit-print-color-adjust: exact !important;
          print-color-adjust: exact !important;
      }
      /* Make form inputs and textareas look like static text */
      input[type="text"], input[type="number"], textarea {
          border: none !important;
          -webkit-appearance: none;
          box-shadow: none !important;
          background: transparent !important;
          font-size: 15px !important;
          color: #000 !important;
          padding: 0 !important;
          margin: 0 !important;
          width: auto !important;
          resize: none !important;
      }
      input[type="text"]:focus, input[type="number"]:focus, textarea:focus {
          outline: none !important;
      }
  }
  input[type="text"], textarea, input[type="date"], input[type="number"] {
      width: 100%; font-size: 16px; padding: 7px 8px; margin-bottom: 8px; box-sizing: border-box;
      border: 1px solid #ccc; border-radius: 5px; transition: border-color 0.3s ease;
  }
  input[type="text"]:focus, textarea:focus, input[type="date"]:focus, input[type="number"]:focus {
      border-color: #3e82ff; outline: none;
  }
  button {
      background-color: #3e82ff; color: white; font-size: 15px; padding: 10px 18px;
      border: none; border-radius: 5px; cursor: pointer; transition: background-color 0.3s ease;
  }
  button:hover {
      background-color: #3165cc;
  }
  .btn-cetak {
      background-color: #27ae60;
      margin-top: 25px;
  }
  .btn-cetak:hover {
      background-color: #1e8449;
  }
  .remove-sparepart-btn {
      background-color: #e74c3c;
      border: none;
      color: white;
      font-weight: bold;
      cursor: pointer;
      border-radius: 5px;
      padding: 5px 10px;
      transition: background-color 0.3s ease;
  }
  .remove-sparepart-btn:hover:not(:disabled) {
      background-color: #c0392b;
  }
  .remove-sparepart-btn:disabled {
      cursor: not-allowed;
      opacity: 0.6;
  }
  #add-sparepart-btn {
      margin-top: 10px;
      background-color: #3e82ff;
      padding: 8px 14px;
      font-weight: 600;
      border-radius: 5px;
  }
</style>
</head>
<body>

<div class="header-info">
    <img src="../assets/images/logo1.png" alt="Logo PT. Cahaya Berkat Mitra" />
    <div class="company-info">
        PT. CAHAYA BERKAT MITRA<br />
        Jl. Raya Imam Bonjol No. 90 RT. 003 RW. 006<br />
        Telaga Murni, Cikarang Barat, Kab. Bekasi, Jawa Barat<br />
        +6281280669996
    </div>
</div>

<div class="info-container" role="region" aria-label="Informasi tagihan dan invoice">
    <div class="bill-to">
        <h3>Bill To:</h3>
        <input type="text" name="manual_penerima" form="invoice-form" value="<?= htmlspecialchars($manual_penerima) ?>" required aria-label="Nama Penerima">
        <div class="delivery-address">
            <strong>Alamat:</strong><br>
            <textarea name="manual_alamat" form="invoice-form" rows="3" required aria-label="Alamat Bongkar"><?= htmlspecialchars($manual_alamat) ?></textarea>
        </div>
    </div>

    <div class="invoice-info" role="region" aria-label="Informasi invoice">
        <div class="title">INVOICE</div>
        <div>
            <strong>Nomor Invoice:</strong>
            <input type="text" name="manual_invoice_no" form="invoice-form" placeholder="Masukkan nomor invoice" aria-label="Nomor Invoice Manual" value="<?= htmlspecialchars($manual_invoice_no) ?>" required>
        </div>
        <div>Tanggal Invoice: <?= htmlspecialchars($invoice_date) ?></div>
        <div>Due Date: <?= htmlspecialchars(date('d F Y', strtotime($due_date))) ?></div>
        <div>
    <label for="metode_pembayaran"><strong>Metode Pembayaran:</strong></label>
            <input type="text" name="metode_pembayaran" form="invoice-form" placeholder="Masukkan metode pembayaran" aria-label="Nomor Invoice Manual" value="<?= htmlspecialchars($metode_pembayaran) ?>" required>
</div>

    </div>
</div>

<table class="table-surat-jalan" border="1" cellpadding="8" cellspacing="0" aria-label="Daftar surat jalan">
<thead>
<tr>
<th>No. Surat Jalan</th>
<th>Nama Barang</th>
<th>nomor polisi</th>
<th style="text-align:right;">Tonase</th>
<th style="text-align:right;">Harga/kg</th>
<th style="text-align:right;">Jumlah Nilai</th>
</tr>
</thead>
<tbody>
<?php foreach ($rows as $row): ?>
<tr>
<td><?= htmlspecialchars($row['no_surat']) ?><br></td>
<td><?= htmlspecialchars($row['jenis_barang']) ?></td>
<td><?= htmlspecialchars($row['no_pol']) ?></td>
<td style="text-align: right;"><?= number_format($row['tonase'], 2) ?></td>
<td style="text-align: right;"><?= number_format($row['harga_kg'], 2) ?></td>
<td style="text-align: right;">
<?php
$calculated_nilai = $row['tonase'] * $row['harga_kg'];
echo number_format($calculated_nilai, 2);
?>
</td>
</tr>
<?php endforeach; ?>
</tbody>
<tfoot>
<tr>
    <td colspan="3" style="text-align: right;">Total:</td>
    <td style="text-align: right;"><?= number_format($total_tonase, 2) ?></td>
    <td></td>
    <td style="text-align: right;"><?= number_format($total_nilai, 2) ?></td>
</tr>
<?php if ($pph > 0): ?>
<tr>
    <td colspan="5" style="text-align: right;">PPH (<?= htmlspecialchars($pph) ?>%):</td>
    <td style="text-align: right;">Rp <?= number_format($pph_amount, 2) ?></td>
</tr>
<?php endif; ?>
<tr>
    <td colspan="5" style="text-align: right;">Charge (Manual Input):</td>
    <td style="text-align: right;">Rp <?= number_format($charge_invoice, 2) ?></td>
</tr>
<tr>
    <td colspan="5" style="text-align: right; font-weight: 700;">Total Setelah Semua Biaya :</td>
    <td style="text-align: right; font-weight: 700;">Rp <?= number_format($total_after_all, 2) ?></td>
</tr>
</tfoot>
</table>

<div class="amounts-box no-print" aria-label="Rincian biaya lainnya">
<strong>Spare Part:</strong>
<ul>
<?php if (count($spareparts) > 0): ?>
    <?php foreach ($spareparts as $sparepart): ?>
        <li><?= htmlspecialchars($sparepart['nama']) ?>: Rp <?= number_format($sparepart['nilai'], 2) ?></li>
    <?php endforeach; ?>
<?php else: ?>
    <li>(Belum ada sparepart diinput)</li>
<?php endif; ?>
</ul>
<div><strong>Uang jalan:</strong> Rp <?= number_format($uang_makan, 2) ?></div>
<div><strong>Uang Kenek:</strong> Rp <?= number_format($uang_kenek, 2) ?></div>
<div><strong>Uang Parkir:</strong> Rp <?= number_format($uang_parkir, 2) ?></div>
</div>

<form method="post" class="pph-form no-print" id="invoice-form" aria-label="Form isi invoice" novalidate>
<table id="spareparts-table" style="width: 100%;">
<thead>
<tr>
<th>Nama Sparepart</th>
<th>Nilai (Rp)</th>
<th>Aksi</th>
</tr>
</thead>
<tbody id="spareparts-tbody">
<?php if (count($spareparts) > 0): ?>
    <?php foreach ($spareparts as $sparepart): ?>
    <tr>
        <td><input type="text" name="sparepart_nama[]" value="<?= htmlspecialchars($sparepart['nama']) ?>" required></td>
        <td><input type="number" name="sparepart_nilai[]" step="0.01" min="0" value="<?= htmlspecialchars($sparepart['nilai']) ?>" required></td>
        <td><button type="button" class="remove-sparepart-btn">-</button></td>
    </tr>
    <?php endforeach; ?>
<?php else: ?>
<tr>
    <td><input type="text" name="sparepart_nama[]" placeholder="Masukkan nama sparepart" required></td>
    <td><input type="number" name="sparepart_nilai[]" step="0.01" min="0" placeholder="0.00" required></td>
    <td><button type="button" class="remove-sparepart-btn" disabled>-</button></td>
</tr>
<?php endif; ?>
</tbody>
</table>
<button type="button" id="add-sparepart-btn">+ Tambah Sparepart</button>

<table id="biaya-lain-table" aria-label="Input biaya lain-lain dan PPH" style="margin-top:20px; width: 100%;">
<thead>
<tr>
<th>Uang jalan (Rp)</th>
<th>Uang Kenek (Rp)</th>
<th>Uang Parkir (Rp)</th>
<th>PPH (%)</th>
<th>Charge (Rp)</th>
<th>Due Date</th>
</tr>
</thead>
<tbody>
<tr>
<td><input type="number" id="uang_makan" name="uang_makan" step="0.01" min="0" value="<?= htmlspecialchars($uang_makan) ?>" required></td>
<td><input type="number" id="uang_kenek" name="uang_kenek" step="0.01" min="0" value="<?= htmlspecialchars($uang_kenek) ?>" required></td>
<td><input type="number" id="uang_parkir" name="uang_parkir" step="0.01" min="0" value="<?= htmlspecialchars($uang_parkir) ?>" required></td>
<td><input type="number" id="pph" name="pph" min="0" max="100" step="0.01" value="<?= htmlspecialchars($pph) ?>" required></td>
<td><input type="number" id="charge_invoice" name="charge_invoice" step="0.01" min="0" value="<?= htmlspecialchars($charge_invoice) ?>" required></td>
<td><input type="date" name="due_date" value="<?= htmlspecialchars($due_date) ?>" required></td>
</tr>
</tbody>
</table>

<?php foreach ($ids as $id): ?>
<input type="hidden" name="selected_ids[]" value="<?= htmlspecialchars($id) ?>">
<?php endforeach; ?>

<button type="submit" name="calculate_total">Hitung Total</button>
</form>

<form method="post" class="save-invoice-form no-print" style="margin-top:15px;" aria-label="Form simpan invoice">
<?php foreach ($ids as $id): ?>
<input type="hidden" name="selected_ids[]" value="<?= htmlspecialchars($id) ?>">
<?php endforeach; ?>
<input type="hidden" name="pph" value="<?= htmlspecialchars($pph) ?>">
<input type="hidden" name="uang_makan" value="<?= htmlspecialchars($uang_makan) ?>">
<input type="hidden" name="uang_kenek" value="<?= htmlspecialchars($uang_kenek) ?>">
<input type="hidden" name="uang_parkir" value="<?= htmlspecialchars($uang_parkir) ?>">
<input type="hidden" name="charge_invoice" value="<?= htmlspecialchars($charge_invoice) ?>">
<input type="hidden" name="manual_penerima" value="<?= htmlspecialchars($manual_penerima) ?>">
<input type="hidden" name="manual_alamat" value="<?= htmlspecialchars($manual_alamat) ?>">
<input type="hidden" name="due_date" value="<?= htmlspecialchars($due_date) ?>">
<input type="hidden" name="manual_invoice_no" value="<?= htmlspecialchars($manual_invoice_no) ?>">
<input type="hidden" name="metode_pembayaran" value="<?= htmlspecialchars($metode_pembayaran) ?>">
<?php
foreach ($spareparts as $sparepart) {
    echo '<input type="hidden" name="sparepart_nama[]" value="' . htmlspecialchars($sparepart['nama']) . '">';
    echo '<input type="hidden" name="sparepart_nilai[]" value="' . htmlspecialchars($sparepart['nilai']) . '">';
}
?>
<button type="submit" name="save_invoice">💾 Simpan Invoice</button>
</form>

<button onclick="window.print()" class="btn-cetak no-print" style="margin-top:20px;">🖨️ Cetak</button>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const addBtn = document.getElementById('add-sparepart-btn');
    const tbody = document.getElementById('spareparts-tbody');

    addBtn.addEventListener('click', () => {
        const row = document.createElement('tr');
        row.innerHTML = \`
            <td><input type="text" name="sparepart_nama[]" placeholder="Masukkan nama sparepart" required></td>
            <td><input type="number" name="sparepart_nilai[]" step="0.01" min="0" placeholder="0.00" required></td>
            <td><button type="button" class="remove-sparepart-btn">-</button></td>
        \`;
        tbody.appendChild(row);
        updateRemoveButtons();
    });

    function updateRemoveButtons() {
        const removeButtons = tbody.querySelectorAll('.remove-sparepart-btn');
        removeButtons.forEach(btn => {
            btn.disabled = removeButtons.length === 1;
            btn.onclick = () => {
                btn.closest('tr').remove();
                updateRemoveButtons();
            };
        });
    }

    updateRemoveButtons();
});
</script>

<div class="payment-info" aria-label="Informasi pembayaran">
    Mohon pembayaran di transfer ke:<br />
    Rek Bank BCA No Rek : 5222406889 a/n PT. Cahaya Berkat Mitra Sarana
</div>

<div class="footer-info" aria-label="Informasi footer">
    <p>Terima kasih</p>
    <p><?= date('d F Y') ?></p>
</div>

</body>
</html>

<?php $conn->close(); ?>

