<?php
// File: surat_jalan/lihat_surat.php
include __DIR__ . '/../config/db.php'; // ✅ ini benar

if (!isset($_GET['id'])) {
    echo "ID tidak ditemukan.";
    exit;
}

$id = intval($_GET['id']);
$sql = "SELECT * FROM surat_jalan WHERE id = $id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    echo "Data tidak ditemukan.";
    exit;
}

$data = $result->fetch_assoc();

$total_tonase = $data['tonase'];
$total_harga_kg = $data['harga_kg'];
$total_jumlah_nilai = $data['jumlah_nilai'];

$invoice_number = 'INV-' . $id . '-' . date('Ymd');

$pph = 0;
if (isset($_POST['pph'])) {
    $pph = floatval($_POST['pph']);
}

$total_setelah_pph = $total_jumlah_nilai + ($total_jumlah_nilai * ($pph / 100));
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Detail Surat Jalan</title>
    <link rel="stylesheet" href="../assets/css/style.css" />
    <style>
        .table-surat-jalan th {
            background-color: rgb(62, 130, 255);
            color: #000;
        }
        .header-info {
            text-align: right;
            margin-bottom: 20px;
        }
        .header-info img {
            float: left;
            margin-right: 10px;
            width: 200px;
        }
        .invoice-number {
            text-align: left;
            font-weight: bold;
            margin-bottom: 5px;
            font-size: 16px;
        }
        .invoice-date {
            text-align: left;
            margin-bottom: 15px;
            color: #555;
            font-size: 14px;
        }
        .footer-info {
            text-align: right;
            margin-top: 30px;
            font-size: 14px;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
        .btn-cetak {
            margin-bottom: 15px;
        }
        .pph-form {
            margin-bottom: 20px;
        }
        @media print {
            .no-print,
            .btn-cetak,
            .pph-form {
                display: none !important;
            }
            body {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
        }
    </style>
</head>
<body>
    <div class="header-info clearfix">
        <br><br><br>
        <img src="../assets/images/logo1.png" alt="Logo PT. Cahaya Berkat Mitra" />
        <div>
            <strong>PT. CAHAYA BERKAT MITRA</strong><br />
            Jl. Raya Imam Bonjol No. 90 RT. 003 RW. 006<br />
            Telaga Murni, Cikarang Barat, Kab. Bekasi, Jawa Barat<br />
            +6281280669996
        </div>
    </div>

    <div class="invoice-number">
        Nomor Invoice: <?= htmlspecialchars($invoice_number) ?>
    </div>
    <div class="invoice-date">
        Tanggal: <?php
            if (!empty($data['tanggal'])) {
                echo date('d F Y', strtotime($data['tanggal']));
            } else if (!empty($data['created_at'])) {
                echo date('d F Y', strtotime($data['created_at']));
            } else {
                echo '-';
            }
        ?>
    </div>

    <h2>Detail Surat Jalan</h2>

    <form method="post" class="pph-form">
        <label for="pph">PPH (isi nilai manual dalam %): </label>
        <input type="number" id="pph" name="pph" min="0" max="100" step="0.01" value="<?= htmlspecialchars($pph) ?>">
        <button type="submit">Hitung Total</button>
    </form>

    <button onclick="window.print()" class="btn-cetak">🖨️ Cetak</button>

    <table class="table-surat-jalan">
        <thead>
            <tr>
                <th>No. Surat Jalan</th>
                <th>No. Pol</th>
                <th>Jenis Barang</th>
                <th>Tujuan</th>
                <th>Tonase</th>
                <th>Harga/kg</th>
                <th>Jumlah Nilai</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= htmlspecialchars($data['no_surat']) ?></td>
                <td><?= htmlspecialchars($data['no_pol']) ?></td>
                <td><?= htmlspecialchars($data['jenis_barang']) ?></td>
                <td><?= htmlspecialchars($data['tujuan']) ?></td>
                <td><?= number_format($total_tonase, 2) ?></td>
                <td><?= number_format($total_harga_kg, 2) ?></td>
                <td><?= number_format($total_jumlah_nilai, 2) ?></td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" style="text-align: right;"><strong>Jumlah:</strong></td>
                <td></td>
                <td><strong><?= number_format($total_jumlah_nilai, 2) ?></strong></td>
                <td></td>
            </tr>
            <?php if ($pph > 0): ?>
            <tr>
                <td colspan="7" style="text-align: right;"><strong>PPH (<?= htmlspecialchars($pph) ?>%):</strong></td>
                <td><strong>- Rp <?= number_format($total_jumlah_nilai * ($pph / 100), 2) ?></strong></td>
            </tr>
            <tr>
                <td colspan="7" style="text-align: right;"><strong>Total Setelah PPh:</strong></td>
                <td><strong>Rp <?= number_format($total_setelah_pph, 2) ?></strong></td>
            </tr>
            <?php endif; ?>
        </tfoot>
    </table>

    <br />
    <a href="list_surat.php" class="no-print">← Kembali ke daftar</a>

    <div class="footer-info">
        <p>Terima kasih</p>
        <p>Cikarang, <?= date('d F Y') ?></p>
    </div>
</body>
</html>
<?php $conn->close(); ?>
