<?php
include __DIR__ . '/../config/db.php';

if ($conn->connect_error) {
    die("Connection failed: " . htmlspecialchars($conn->connect_error));
}

$search = '';
if (isset($_POST['search'])) {
    $search = $_POST['search'];
}

$next_month = date('Y-m-d', strtotime('+30 days'));

if ($search) {
    $sql = "SELECT * FROM invoice 
            WHERE (no_invoice LIKE ? 
                OR total_tonase LIKE ? 
                OR total_nilai LIKE ? 
                OR pph LIKE ? 
                OR total_after_pph LIKE ?)
            AND due_date <= ?
            ORDER BY due_date ASC";
    $likeSearch = "%".$search."%";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Prepare failed: " . htmlspecialchars($conn->error));
    }
    $stmt->bind_param("ssssss", $likeSearch, $likeSearch, $likeSearch, $likeSearch, $likeSearch, $next_month);
    $stmt->execute();
    if ($stmt->error) {
        die("Query error: " . htmlspecialchars($stmt->error));
    }
    $result = $stmt->get_result();
} else {
    // Modified query to show ALL invoices ignoring due_date filter for debugging
    // Change this back to original if you want to filter invoices by due_date again
    // $sql = "SELECT * FROM invoice WHERE due_date <= ? ORDER BY due_date ASC";

    $sql = "SELECT * FROM invoice ORDER BY due_date ASC";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die("Prepare failed: " . htmlspecialchars($conn->error));
    }
    // If you want to apply due_date filter again, uncomment below and comment out the new $sql and bind_param
    // $stmt->bind_param("s", $next_month);
    $stmt->execute();
    if ($stmt->error) {
        die("Query error: " . htmlspecialchars($stmt->error));
    }
    $result = $stmt->get_result();
}

if (!$result) {
    die("Query failed: " . htmlspecialchars($conn->error));
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Daftar Invoice Jatuh Tempo</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #6a11cb, #2575fc);
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 12px 30px rgba(0,0,0,0.15);
        }
        h2 {
            color: #2575fc;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 14px 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: rgb(62, 130, 255);
            color: white;
            font-weight: 700;
        }
        tbody tr:nth-child(even) {
            background-color: #f7f9fc;
        }
        a.action-link {
            margin-right: 10px;
            text-decoration: none;
            color: #007bff;
        }
        a.action-link:hover {
            text-decoration: underline;
        }
        .no-print {
            margin-top: 20px;
            display: block;
            text-align: center;
            color: #2575fc;
            font-weight: bold;
        }
        .no-print:hover {
            text-decoration: underline;
        }
        form.search-form {
            margin-bottom: 20px;
            text-align: center;
        }
        form.search-form input[type="text"] {
            width: 300px;
            padding: 8px 12px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 16px;
        }
        form.search-form button {
            padding: 8px 16px;
            background-color: #2575fc;
            border: none;
            color: white;
            border-radius: 6px;
            font-weight: bold;
            cursor: pointer;
            margin-left: 8px;
        }
        form.search-form button:hover {
            background-color: #1a54d6;
        }
        /* Small debug info */
        .debug-info {
            background-color: #eee;
            border: 1px solid #ccc;
            padding: 12px;
            margin-top: 16px;
            font-family: monospace;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Invoice Jatuh Tempo (30 Hari ke Depan)</h2>
        <form method="POST" action="" class="search-form">
            <input type="text" name="search" placeholder="Cari Invoice..." value="<?= htmlspecialchars($search) ?>" />
            <button type="submit">Cari</button>
        </form>

        <div class="debug-info">
            Jumlah invoice: <?= $result->num_rows ?><br>
        </div>

        <table>
            <thead>
                <tr>
                    <th>No. Invoice</th>
                    <th>Total Tonase</th>
                    <th>Total Nilai</th>
                    <th>PPH</th>
                    <th>Total Setelah PPh</th>
                    <th>Tanggal Dibuat</th>
                    <th>Jatuh Tempo</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['no_invoice']) ?></td>
                            <td><?= number_format($row['total_tonase'], 2) ?></td>
                            <td><?= number_format($row['total_nilai'], 2) ?></td>
                            <td><?= number_format($row['pph'], 2) ?></td>
                            <td><?= number_format($row['total_after_pph'], 2) ?></td>
                            <td><?= date('d F Y', strtotime($row['created_at'])) ?></td>
                            <td><?= date('d F Y', strtotime($row['due_date'])) ?></td>
                            <td>
                                <a class="action-link" href="detail_invoice.php?id=<?= urlencode($row['id']) ?>">Lihat</a>
                                <a class="action-link" href="?page=update_invoice&id=<?= urlencode($row['id']) ?>">Update</a>
                                <a class="action-link" href="?page=delete_invoice&id=<?= urlencode($row['id']) ?>" onclick="return confirm('Yakin ingin menghapus invoice ini?');">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center;">Tidak ada invoice yang ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <br>
        <a href="?page=invoice_surat_jalan" class="no-print">← Kembali ke Halaman Invoice</a>
    </div>
</body>
</html>
<?php
if ($stmt) { $stmt->close(); }
$conn->close();
?>

