<?php
include __DIR__ . '/../config/db.php';

$sql = "SELECT * FROM surat_jalan ORDER BY id DESC";
$result = $conn->query($sql);

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Daftar Surat Jalan</title>
<style>
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #6a11cb, #2575fc);
    margin: 0;
    padding: 20px;
    color: #333;
  }
  .container {
    max-width: 1200px;
    margin: auto;
    background: white;
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 12px 30px rgba(0,0,0,0.15);
  }
  h1 {
    margin-bottom: 20px;
    color: #2575fc;
    text-align: center;
  }
  a.button-add {
    display: inline-block;
    margin-bottom: 20px;
    padding: 10px 18px;
    background-color: #2575fc;
    color: white;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 600;
    transition: background-color 0.3s ease;
  }
  a.button-add:hover {
    background-color: #1a55d7;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 25px;
  }
  th, td {
    padding: 14px 12px;
    border: 1px solid #ddd;
    text-align: left;
  }
  th {
    background-color: #6a11cb;
    background-image: linear-gradient(135deg, #6a11cb, #2575fc);
    color: white;
    font-weight: 700;
  }
  tbody tr:nth-child(even) {
    background-color: #f7f9fc;
  }
  button.submit-invoice {
    background-color: #2575fc;
    color: white;
    border: none;
    padding: 12px 22px;
    border-radius: 6px;
    font-size: 16px;
    cursor: pointer;
    font-weight: 600;
    transition: background-color 0.3s ease;
  }
  button.submit-invoice:hover {
    background-color: #1a55d7;
  }
</style>
</head>
<body>
<div class="container">
  <h1>Daftar Surat Jalan</h1>
  <a href="input_surat.php" class="button-add">+ Tambah Surat Jalan</a>

  <form method="post" action="invoice_surat_jalan.php">
    <table>
      <thead>
        <tr>
          <th>Pilih</th>
          <th>No.</th>
          <th>Tanggal</th>
          <th>No. Surat</th>
          <th>No. Polisi</th>
          <th>Jenis Barang</th>
          <th>Tujuan</th>
          <th>Tonase</th>
          <th>Harga/Kg</th>
          <th>Jumlah Nilai</th>
          <th>Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result->num_rows > 0): $no=1; ?>
          <?php while($row = $result->fetch_assoc()): ?>
            <tr>
              <td><input type="checkbox" name="selected_ids[]" value="<?= $row['id'] ?>"></td>
              <td><?= $no++ ?></td>
              <td><?= date('d F Y', strtotime($row['tanggal'])) ?></td>
              <td><?= htmlspecialchars($row['no_surat']) ?></td>
              <td><?= htmlspecialchars($row['no_pol']) ?></td>
              <td><?= htmlspecialchars($row['jenis_barang']) ?></td>
              <td><?= htmlspecialchars($row['tujuan']) ?></td>
              <td><?= number_format($row['tonase'], 2) ?></td>
              <td><?= number_format($row['harga_kg'], 2) ?></td>
              <td><?= number_format($row['jumlah_nilai'], 2) ?></td>
              <td>
                 <a href="lihat_surat.php?id=<?= $row['id'] ?>">Lihat</a> |
                 <a href="edit_surat.php?id=<?= $row['id'] ?>">Edit</a> |
                 <a href="delete_surat.php?id=<?= $row['id'] ?>" onclick="return confirm('Yakin ingin menghapus?')">Hapus</a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="11" style="text-align:center;">Belum ada data surat jalan.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
    <button type="submit" class="submit-invoice">Buat Invoice dari Surat Jalan Terpilih</button>
  </form>
</div>
</body>
</html>
<?php
$conn->close();
?>