<?php
// File: surat_jalan/save_surat.php
include '../config/db.php';

// Enable error reporting for debugging
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil data dari form dan trim inputs
    $no_surat = trim($_POST['no_surat']);
    $no_pol = trim($_POST['no_pol']);
    $jenis_barang = trim($_POST['jenis_barang']);
    $tujuan = trim($_POST['tujuan']);
    $tonase = $_POST['tonase'];
    $harga_kg = $_POST['harga_kg'];
    $charge = $_POST['charge'];

    // Debug: Log inputs
    error_log("Received inputs: no_surat=$no_surat, no_pol=$no_pol, jenis_barang=$jenis_barang, tujuan=$tujuan, tonase=$tonase, harga_kg=$harga_kg, charge=$charge");

    // Validate numeric
    if (!is_numeric($tonase)) {
        die("Tonase harus berupa angka.");
    }
    if (!is_numeric($harga_kg)) {
        die("Harga / kg harus berupa angka.");
    }
    if (!is_numeric($charge)) {
        die("Charge harus berupa angka.");
    }

    // Prepare statement with error checking
    $sql = "INSERT INTO surat_jalan (no_surat, no_pol, jenis_barang, tujuan, tonase, harga_kg, charge) VALUES (?, ?, ?, ?, ?, ?, ?)";
    try {
        $stmt = $conn->prepare($sql);
    } catch (mysqli_sql_exception $e) {
        die("Prepare failed: " . $e->getMessage());
    }

    // Bind parameters - note 'd' for double (float) for numeric values
    try {
        $stmt->bind_param("ssssdds", $no_surat, $no_pol, $jenis_barang, $tujuan, $tonase, $harga_kg, $charge);
    } catch (mysqli_sql_exception $e) {
        die("Binding parameters failed: " . $e->getMessage());
    }
    if ($stmt->execute()) {
        echo "<script>alert('Data berhasil disimpan!'); window.location.href='list_surat.php';</script>";
    } else {
        echo "Gagal menyimpan data: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>