<?php
// File: surat_jalan/update_invoice.php
include '../config/db.php';

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $stmt = $conn->prepare("SELECT * FROM invoice WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $invoice = $result->fetch_assoc();

    if (!$invoice) {
        echo "Invoice tidak ditemukan.";
        exit;
    }
} else {
    echo "ID invoice tidak diberikan.";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $no_invoice = $_POST['no_invoice'];
    $total_tonase = floatval($_POST['total_tonase']);
    $total_nilai = floatval($_POST['total_nilai']);
    $pph = floatval($_POST['pph']);
    $total_after_pph = floatval($_POST['total_after_pph']);

    $stmt = $conn->prepare("UPDATE invoice SET no_invoice = ?, total_tonase = ?, total_nilai = ?, pph = ?, total_after_pph = ? WHERE id = ?");
    $stmt->bind_param("sddddi", $no_invoice, $total_tonase, $total_nilai, $pph, $total_after_pph, $id);
    
    if ($stmt->execute()) {
        echo "<script>alert('Invoice berhasil diupdate.'); window.location.href='list_invoice.php';</script>";
    } else {
        echo "<script>alert('Gagal mengupdate invoice: " . $stmt->error . "');</script>";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <body>
    <h2>Update Invoice</h2>
    <form method="post">
        <label for="no_invoice">Nomor Invoice:</label><br>
        <input type="text" id="no_invoice" name="no_invoice" value="<?= htmlspecialchars($invoice['no_invoice']) ?>" required><br><br>

        <label for="total_tonase">Total Tonase:</label><br>
        <input type="number" step="0.01" id="total_tonase" name="total_tonase" value="<?= htmlspecialchars($invoice['total_tonase']) ?>" required><br><br>

        <label for="total_nilai">Total Nilai:</label><br>
        <input type="number" step="0.01" id="total_nilai" name="total_nilai" value="<?= htmlspecialchars($invoice['total_nilai']) ?>" required><br><br>

        <label for="pph">PPH (%):</label><br>
        <input type="number" step="0.01" id="pph" name="pph" value="<?= htmlspecialchars($invoice['pph']) ?>" required><br><br>

        <label for="total_after_pph">Total Setelah PPh:</label><br>
        <input type="number" step="0.01" id="total_after_pph" name="total_after_pph" value="<?= htmlspecialchars($invoice['total_after_pph']) ?>" required><br><br>

        <button type="submit">Update Invoice</button>
    </form>

    <br>
    <a href="list_invoice.php">← Kembali ke Daftar Invoice</a>
</body>
</html>

<?php
$conn->close();
?>